/* global folder, parameters */

// merge default parameters with active folder parameters
parameters = require('/agorum/roi/customers/cdev.ncore/js/utils/parse')(
  Object.assign({ limit: '10', debug: 'cache', logging: 'true' }, parameters));

// Object.keys(require.cache).forEach(key => delete require.cache[key]);
let config = {
  debug: parameters.debug,
  path: '/agorum/roi/customers/isg.xpert.archive/js/af-archive.js',
  prefix: '[isg.xpert.archive]'
};

let $$ = require('cdev/debug')(config);

$$.debug(folder, parameters, $$.environment);

let objects = require('common/objects');
let metadata = require('common/metadata');
let transaction = require('common/transaction');

let utils = require('./idx-utils');
let archive = require('./archive');

let active = parameters.active;
let logging = parameters.logging;
let limit = Number(parameters.limit);

$$.cache.write('logging', logging);

// TODO: check if buffer and errors folder exists
//       and throw error if not found

let buffer = objects.query(parameters.buffer).find()[0];
let errors = objects.query(parameters.errors).find()[0];
let ignore = objects.query(parameters.ignore).find()[0];

// $$.debug(buffer, errors, active);

function processTriggerFile(item, parms) {
  let {buffer, errors, ignore} = parms;
  $$.log('found trigger [{0}]'.format(item.name));
  let path = utils.splitPath(item.name);
  let idx = null,
    content = null,
    meta = null,
    processError = false,
    processCode = '0';
  objects.unlink(item); // unlink ok file to prevent reprocessing
  try {
    // find idx file based on filename from ok file
    idx = folder.getItem(path.name + '.idx');
    if (!idx) throw new Error('idx file for [{0}] not found'.format(item.name));
    $$.log('found index [{0}]'.format(idx.name));
    // process the idx file and save metadata to idx file for debugging
    content = utils.convertContent(idx.contentStream, utils.IDX_CHARSET);
    meta = utils.convertToJSON(content, utils.PREFIX);
    metadata(meta).save(idx); // save metadata to idx file for debugging
    // check processCode and throw error if not 0
    processCode = meta[utils.PREFIX + 'processCode'];
    if (processCode !== '0')
      throw new Error('skipping [{0}] because of invalid processCode [{1}]'.format(idx.name, processCode));
    // check all image files and throw error if not found
    $$.debug('using document base path [{0}]'.format(path.base), meta);
    if (!meta[utils.PREFIX + 'images'] || meta[utils.PREFIX + 'images'].length === 0)
      throw new Error('no image files found for [{0}]'.format(idx.name));
    utils.moveImages(idx, meta, [buffer], true);
    // move idx to buffer and run archive process
    objects.unlink(idx);
    objects.link(idx, buffer);
    $$.log('moved [{0}] to [{1}]'.format(idx.name, buffer.name));
  } catch (error) {
    processError = true;
    // log error and move all files to error folder
    let label = processCode === '0' ? 'ERROR' : 'IGNORE';
    let target = processCode === '0' ? errors : ignore;
    $$.debug(label, error);
    $$.log(label + ' ' + error.message);
    let pdf = folder.getItem(path.base + '.pdf');
    if (pdf) {
      // process stale pdf file
      objects.unlink(pdf);
      objects.link(pdf, target);
      $$.log('moved [{0}] to [{1}]'.format(pdf.name, target.name));
    }
    if (idx) {
      meta[utils.PREFIX + 'processError'] = error.message;
      metadata(meta).save(idx); // save metadata to idx file for debugging
      objects.unlink(idx);
      objects.link(idx, target);
      $$.log('moved [{0}] to [{1}]'.format(idx.name, target.name));
      try {
        utils.moveImages(idx, meta, [target], true);
      } catch (error) {
        $$.debug('ERROR', error);
        $$.log('ERROR ' + error.message);
      }
    }
  }
  if (!processError) {
    // run archive process in transaction
    transaction(() => {
      archive.processDocument(idx, meta);
    });
  }
}

// Replace the forEach content with function call
if (active == true && buffer && errors) {
  let query = 'inpath:{0} classname:fileobject'.format(folder.ID);
  (
    objects
      .query(query + ' nameextension:ok')
      .limit(limit)
      .find() || []
  ).forEach(item => {
    processTriggerFile(item, {buffer, errors, ignore});
  });
}
